var Car_Inspection_Reminder = client.getTable('Car_Inspection_Reminder');

var oInputInspReminderSearch = new sap.m.Input({
    width:"300px",
    placeholder: "Search License, Driver Email/ID"
});

var oButtonSearchInspReminder = new sap.m.Button({
    text: "GO",
    type: "Emphasized", // You can change to "Transparent" for smaller style
    press: function () {
        var inputValue = oInputInspReminderSearch.getValue();
        console.log("Input value:", inputValue);
        funGetInspectionReminderDetailsFromDb(inputValue,'0')
    }
});

var oHBoxInspReminderSearch = new sap.m.HBox({
    items: [oInputInspReminderSearch, oButtonSearchInspReminder],
    alignItems: "Center",
    justifyContent: "Start"
});

var oTable4WGrabInspReminder = new sap.m.Table({growing: true,mode: "SingleSelectMaster",noDataText: oBundle.getText("No_Data"),
    growingTriggerText: oBundle.getText("More"),growingThreshold: 25,mode:"None",growingScrollToLoad: false,
    sticky: [sap.m.Sticky.ColumnHeaders, sap.m.Sticky.HeaderToolbar, sap.m.Sticky.InfoToolbar],
    columns: [
        new sap.m.Column({ width: "100px", header: new sap.m.Label({ text: oBundle.getText("Action"), design: sap.m.LabelDesign.Bold }) }),
        new sap.m.Column({ header: new sap.m.Label({ wrapping:true, text: oBundle.getText("Driver"), design: sap.m.LabelDesign.Bold }),
        minScreenWidth: "Phone",demandPopin: true, popinDisplay: "Inline" }),
        new sap.m.Column({ header: new sap.m.Label({wrapping:true, text: oBundle.getText("License_Number"), design: sap.m.LabelDesign.Bold}),
        minScreenWidth: "Tablet", demandPopin: true, popinDisplay: "Inline"  }),
        new sap.m.Column({ header: new sap.m.Label({wrapping:true, text: oBundle.getText("Booking_Detail"), design: sap.m.LabelDesign.Bold }),
        minScreenWidth: "Desktop", demandPopin: true, popinDisplay: "Inline"}),
        new sap.m.Column({header: new sap.m.Label({wrapping:true, text: oBundle.getText("Booking_Location"), design: sap.m.LabelDesign.Bold }),
        minScreenWidth: "Desktop", demandPopin: true, popinDisplay: "Inline"}),
        new sap.m.Column({header: new sap.m.Label({wrapping:true, text: oBundle.getText("Inspection_Detail"), design: sap.m.LabelDesign.Bold }),
        minScreenWidth: "Tablet", demandPopin: true, popinDisplay: "Inline"}),
        new sap.m.Column({header: new sap.m.Label({wrapping:true, text: oBundle.getText("Status"), design: sap.m.LabelDesign.Bold }),
        minScreenWidth: "Desktop", demandPopin: true, popinDisplay: "Inline"}),
        new sap.m.Column({header: new sap.m.Label({wrapping:true, text: oBundle.getText("Start_Date"), design: sap.m.LabelDesign.Bold }),
        minScreenWidth: "Desktop", demandPopin: true, popinDisplay: "Inline"}),
        new sap.m.Column({header: new sap.m.Label({wrapping:true, text: oBundle.getText("Due_Date"), design: sap.m.LabelDesign.Bold }),
        minScreenWidth: "Desktop", demandPopin: true, popinDisplay: "Inline"}),
       
]});
var inspReminderSearch =  new sap.m.SearchField({
    placeholder: oBundle.getText("Search"),
    width: "300px",
    liveChange: function (event) {
        var oBinding = oTable4WGrabInspReminder.getBinding("items");
        var searchStr = this.getValue();
        if (oBinding) {
            var oFilters = [
                new sap.ui.model.Filter("driver_name", sap.ui.model.FilterOperator.Contains, searchStr),
                new sap.ui.model.Filter("booking_id", sap.ui.model.FilterOperator.Contains, searchStr),
                new sap.ui.model.Filter("due_date", sap.ui.model.FilterOperator.Contains, searchStr),
                new sap.ui.model.Filter("inspection_date", sap.ui.model.FilterOperator.Contains, searchStr),
                new sap.ui.model.Filter("inspection_number", sap.ui.model.FilterOperator.Contains, searchStr),
                new sap.ui.model.Filter("license_number", sap.ui.model.FilterOperator.Contains, searchStr),
                new sap.ui.model.Filter("jaya_driver_id", sap.ui.model.FilterOperator.Contains, searchStr),
                new sap.ui.model.Filter("location_name", sap.ui.model.FilterOperator.Contains, searchStr),
                new sap.ui.model.Filter("status", sap.ui.model.FilterOperator.Contains, searchStr),
                new sap.ui.model.Filter("handover_date", sap.ui.model.FilterOperator.Contains, searchStr),
                new sap.ui.model.Filter("driver_type", sap.ui.model.FilterOperator.Contains, searchStr)
            ];
            var filterObj = new sap.ui.model.Filter(oFilters, false);
            oBinding.filter(filterObj);
        } else {
            oBinding.filter([]);
        }
    }

});
oTable4WGrabInspReminder.setHeaderToolbar(new sap.m.Toolbar({
    content: [
        oHBoxInspReminderSearch,
        new sap.m.ToolbarSpacer(),
        inspReminderSearch
       
    ]
}));
var inspReminderTemplate = new sap.m.ColumnListItem({
    cells: [
        new sap.m.Button({type: "Emphasized",icon: "sap-icon://action",text: oBundle.getText("Action"),
            press: function (event) {
                var model = this.getModel();
                var path = event.getSource().getBindingContext().getPath();
                var obj1 = model.getProperty(path);
                displayMenuInspectionReminder(event, obj1);
            }
        }),
        new sap.m.VBox({
            items:[
                new sap.m.Label({ wrapping: true, text: "{driver_name}" }),
                // new sap.m.Label({ wrapping: true, text: "{driver_type}" }),
                new sap.m.Label({
                    wrapping: true,
                    text: {
                      path: "driver_type",
                      formatter: function (driverTypeId) {
                        const driverTypeMap = driverTypeArray;
                        return driverTypeMap[driverTypeId] || driverTypeId;
                      }
                    }
                  }).addStyleClass("sapUiTinyMarginTop"),
                new sap.tnt.InfoLabel({colorScheme:6,
                    text: { path: "restriction_flag",
                        formatter: function (restriction_flag) {
                            if (restriction_flag == "1") {
                                this.setColorScheme(3); // Info (Blue)
                                return "Restricted";
                            }else{
                                this.setVisible(false)
                            }
                            
                        }
                    }}),
                 
            ]
        }),
        new sap.m.Label({ wrapping:true, text: "{license_number}"}),
        new sap.m.VBox({
            items:[
                new sap.m.Label({ wrapping: true, text: "{booking_id}" }),
                new sap.m.Label({
                    text: {
                        path: "booking_slot", // Replace with your actual path (e.g. slot_column)
                        formatter: function (value) {

                            if(value == 'slot8_9'){ return "Slot 8:00 - 9:00"; 
                            }else if(value == 'slot9_10'){   return "Slot 9:00 - 10:00";
                            }else if(value == 'slot10_11'){ return "Slot 10:00 - 11:00";
                            }else if(value == 'slot11_12'){ return "Slot 11:00 - 12:00";
                            }else if(value == 'slot12_13'){ return "Slot 12:00 - 13:00";
                            }else if(value == 'slot13_14'){ return "Slot 13:00 - 14:00";
                            }else if(value == 'slot14_15'){ return "Slot 14:00 - 15:00";
                            }else if(value == 'slot15_16'){ return "Slot 15:00 - 16:00";
                            }else if(value == 'slot16_17'){ return "Slot 16:00 - 17:00";
                            }else if(value == 'slot17_18'){ return "Slot 17:00 - 18:00";
                            }else if(value == 'slot18_18'){ return "Slot 18:00 - 19:00";}
                        }
                    }
                }),
                
                new sap.m.Label({ wrapping: true, text: "{booking_date}" }).addStyleClass(""),
            ]
        }),
        new sap.m.VBox({
            items:[
                new sap.m.Label({ wrapping: true, text: "{location_id}" }),
                new sap.m.Label({ wrapping: true, text: "{location_name}" }),
            ]
        }),
        // new sap.m.Label({ wrapping:true, text: "{booking_created_date}"}),
        new sap.m.VBox({
            items:[
                new sap.m.Label({ wrapping: true, text: "{inspection_number}" }),
                // new sap.m.Label({ wrapping: true, text: "{inspection_location_id}" }),
                new sap.m.Label({ wrapping: true, text: "{inspection_date}" }).addStyleClass(""),
            ]
        }),
        // new sap.m.Label({ wrapping:true, text: "{status}"}),
        new sap.tnt.InfoLabel({colorScheme:6,
            text: { path: "status",
                formatter: function (status) {
                    if (status == "Done") {
                        this.setColorScheme(6); // Info (Blue)
                        return "Done";
                    }else if (status == "Open") {
                        this.setColorScheme(9); // Info (Grey)
                        return "Open";
                    }else if (status == "Scheduled") {
                        this.setColorScheme(8); // Info (Green)
                        return "Scheduled";
                    }else if (status == "No Show") {
                        this.setColorScheme(1); // Info (orange)
                        return "No Show";
                    }else if (status == "Expired") {
                        this.setColorScheme(2); // Info (Red)
                        return "Expire";
                    }else{
                        this.setVisible(false)

                    }
                    
                }
            }
        }),
        new sap.m.Label({wrapping:true,text: "{booking_start_date}"}),
        new sap.m.Label({wrapping:true,text: "{due_date}"})
    
        // new sap.m.VBox({
        //     items:[ 
        //         new sap.m.Label({wrapping:true,text: "{booking_start_date}"}),
        //         new sap.m.Label({wrapping:true,text: "{due_date}"})
        //     ]       
        // })
    ],
});


function displayMenuInspectionReminder(event,obj){

    var oMenu = new sap.m.Menu({
        items: [
            new sap.m.MenuItem({visible:true, icon: "sap-icon://show",text: oBundle.getText("View"),key: "0"}),
        ],
        itemSelected: function (oEvent) {
            var oItem = oEvent.getParameter("item").getKey();
             var mid = obj['id'];
            if (oItem == "0") {
                // createUpdateDriver(3,obj);
                viewInspectionReminder(obj)
            } else if (oItem == "3") {
                var oDialog = new sap.m.Dialog({
                    title: oBundle.getText("Alert"),
                    state: sap.ui.core.ValueState.Error,
                    content: [new sap.m.Label({ text: oBundle.getText("Sure_You_want_to_delete") })],
                    buttons: [
                                new sap.m.Button({text: oBundle.getText("Delete"),icon: "sap-icon://delete",
                                    press: function () {
                                        busyDialog.open();
                                        Car_Driver_Master.del({ id: obj['id'] }).done(function () {
                                            getDriverData();
                                            oDialog.close();
                                            busyDialog.close();
                                        });
                                    }
                                }),
                                new sap.m.Button({text: oBundle.getText("Cancel"),icon: "sap-icon://decline",
                                    press: function () {
                                        oDialog.close();
                                    }
                                })
                            ]
                }).open();
            } 
        }
    });
    // getDeleteMenu(oMenu,"3");

    oMenu.openBy(event.getSource());
};

function viewInspectionReminder(obj){



    var formView = new sap.uxap.ObjectPageLayout({ headerContentPinnable: true, preserveHeaderStateOnScroll: true,
        useIconTabBar: true,
        headerContent: [
            new sap.ui.layout.VerticalLayout({content: [
                new sap.m.Title({ text: "Reminder Info :", level: "H4" }),
                new sap.m.ObjectStatus({title: oBundle.getText("Vehicle_Id"),text:obj['vehicle_id']}),
                new sap.m.ObjectStatus({title: oBundle.getText("License_Plate"),text:obj['license_number']}),
                new sap.m.ObjectStatus({title: oBundle.getText("Location_ID"),text:obj['location_id']}),
                new sap.m.ObjectStatus({title: oBundle.getText("Location_Name"),text:obj['location_name']}),
                new sap.m.ObjectStatus({title: oBundle.getText("Status"),text:obj['status']}),
                new sap.m.ObjectStatus({title: oBundle.getText("Start_Date"),text:obj['booking_start_date']}),
                new sap.m.ObjectStatus({title: oBundle.getText("Due_Date"),text:obj['due_date']}),
            ]}),
            new sap.ui.layout.VerticalLayout({content: [
                new sap.m.Title({ text: "Driver Info :", level: "H4" }),
                new sap.m.ObjectStatus({title: oBundle.getText("Driver_Name"),text:obj['driver_name']}),
                new sap.m.ObjectStatus({title: oBundle.getText("Driver_Type"),text:driverTypeArray[obj['driver_type']]}),
                new sap.m.ObjectStatus({title: oBundle.getText("Driver_Email"),text:obj['driver_email']}),
                new sap.m.ObjectStatus({title: oBundle.getText("Booking_Start_Date"),text:obj['booking_start_date']}),
                new sap.m.ObjectStatus({title: oBundle.getText("Booking_ID"),text:obj['booking_id']}),
                new sap.m.ObjectStatus({title: oBundle.getText("Booking_Date"),text:obj['booking_date']}),
                // new sap.m.ObjectStatus({title: oBundle.getText("Booking Created Date"),text:obj['booking_created_date']}),
                new sap.m.ObjectStatus({title: oBundle.getText("Booking_Slot"),text:obj['booking_slot']}),
                
            ]}),            
            new sap.ui.layout.VerticalLayout({content: [
                new sap.m.Title({ text: "Inspection Info : ", level: "H4" }),
                // new sap.m.ObjectStatus({title: oBundle.getText("Inspection_ID"),text:obj['inspection_id']}),
                new sap.m.ObjectStatus({title: oBundle.getText("Inspection_Number"),text:obj['inspection_number']}),
                new sap.m.ObjectStatus({title: oBundle.getText("Inspection_Date"),text:obj['inspection_date']}),
                new sap.m.ObjectStatus({title: oBundle.getText("Inspection_Location_ID"),text:obj['inspection_location_id']}),
                new sap.m.ObjectStatus({title: oBundle.getText("Restriction_Flag"),text:obj.restriction_flag ? "Restriced" : ""}),
            ]}),            
        ]
    });


    // Create the Dialog
    var oDialog = new sap.m.Dialog({
        title: "Inspection Reminder",
        contentWidth: "60%",
        content: [
            formView
        ],
        beginButton: new sap.m.Button({
            text: "Close",
            press: function () {
                oDialog.close();
            }
        }),
        afterClose: function () {
            oDialog.destroy();
        }
    }).open();

};



var inspReminderPage4W = new sap.m.Page("inspection_reminder_page_4w", {
    title:oBundle.getText("Inspection_Reminder"),
    showHeader:true,
    enableScrolling:true,
    content : [oTable4WGrabInspReminder] 
}); 